
import cadquery as cq

# Updated dimensions for the outer and inner radius, and increased height
outer_radius = 10.0  # Keeping the same outer radius
inner_radius = 7.0   # Adjusting to visually emphasize a 'medium-sized' inner radius
height = 200.0       # Doubling the height to emphasize the length

result = cq.Workplane("XY").circle(outer_radius).extrude(height)

inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)

result = result.cut(inner_cylinder)

result.val().exportStl("Refine_V_1.stl")
