
import cadquery as cq

# Define the side length of the square which should be equal to the extrusion height to form a cube
side_length = 10.0
extrusion_height = side_length  # Updated to ensure the height matches the side length to form a cube

result = (
    cq.Workplane("XY")
    .rect(side_length, side_length)
    .extrude(extrusion_height)
)

# Save the output as STL file with the specified name in the feedback
result.val().exportStl("Refine_V_1.stl")
