
import cadquery as cq

table_length = 90.0
table_width = 60.0
table_thickness = 2.0

leg_length = table_length / 3.0
leg_width = 5.0
leg_height = table_thickness  # Updated to match table thickness

table = cq.Workplane("XY").box(table_length, table_width, table_thickness)

leg1 = (
    cq.Workplane("XY")
    .workplane(offset=-leg_height)
    .moveTo(-table_length / 2 + leg_length / 2, 0)
    .box(leg_length, leg_width, leg_height)
)

leg2 = (
    cq.Workplane("XY")
    .workplane(offset=-leg_height)
    .moveTo(table_length / 2 - leg_length / 2, 0)
    .box(leg_length, leg_width, leg_height)
)

result = table.union(leg1).union(leg2)

result.val().exportStl("Refine_V_2.stl")
