
import cadquery as cq
import math

# Define the side length of the hexagon
side_length = 10.0
# Calculate the radius of the circle that circumscribes the hexagon
radius = side_length / math.sqrt(3)

# Create a workplane to draw the hexagon
result = cq.Workplane("XY")

# Move the initial point to the right side on the X-axis
result = result.moveTo(radius, 0)

# Draw the hexagon by adding points at 60 degrees intervals
for i in range(1, 7):
    angle_deg = 60 * i
    angle_rad = math.radians(angle_deg)
    result = result.lineTo(radius * math.cos(angle_rad), radius * math.sin(angle_rad))

# Close the polyline to form a hexagon and extrude it
result = result.close().extrude(5.0)

# Export the result as an STL file
result.val().exportStl("Refine_V_2.stl")
