
import cadquery as cq

# Define dimensions based on feedback
rectangle_length = 15.0              # Given length of the rectangle
rectangle_width = rectangle_length / 1.5  # Width is 1.5 times less than length
rectangle_thickness = 0.5            # Thickness of the base rectangle
rod_length = 1.0                     # Width of the rod
rod_width = 1.0                      # Length of the rod at the base (it's a square rod)
rod_height = 45.0                    # Height of the rod, 3 times the rectangle length (15 * 3)

# Construct the rectangle and extrude it slightly
result = (
    cq.Workplane("XY")
    .rect(rectangle_length, rectangle_width)
    .extrude(rectangle_thickness)
)

# Adding the rod at the corner of the rectangle
result = (
    result
    .faces(">Z")
    .workplane(centerOption="CenterOfMass")  # Ensures positioning relative to face center
    .transformed(offset=(rectangle_length/2 - rod_length/2, rectangle_width/2 - rod_width/2, 0))
    .rect(rod_length, rod_width)
    .extrude(rod_height)
)

# Export the result as STL
result.val().exportStl("Refine_V_1.stl")
