
import cadquery as cq

width = 10.0  # The overall width of the tag
height = 20.0 # The overall height of the tag
thickness = 1.0  # Updated thickness making it thinner
radius = width / 2.0 # Radius of the semi-circle at the bottom

# Calculate the hole diameter to be 1/4th of the semi-circle's diameter
hole_diameter = radius / 4

# Creating the tag with a U shape and a semi-circular bottom
result = (
    cq.Workplane("front")
    .moveTo(-width / 2, 0)
    .hLine(width)  # Bottom horizontal line
    .vLine(height - radius)  # Right vertical line of rectangle
    .threePointArc((0, height), (-width / 2, height - radius))  # Semi-circle on top of the rectangle
    .vLine(-(height - radius))  # Left vertical line
    .close()  # Close the sketch to form the U-Shape
    .extrude(thickness)
    # Centering the hole on the semi-circle
    .faces(">Z")
    .workplane()
    .moveTo(0, height - radius / 2)
    .hole(hole_diameter)
)
# Saving the result in the STL format
result.val().exportStl("Refine_V_1.stl")
