
import cadquery as cq

# Define dimensions of the plate
length = 10    # Length of the long side
width = 5      # Width of the short side
thickness = 0.1 # Thickness of the plate

# Create an L-shaped object
result = cq.Workplane("XY")
result = result.moveTo(-width/2, 0).lineTo(width/2, 0)
result = result.lineTo(width/2, length).lineTo(-width/2, length)
result = result.lineTo(-width/2, width).lineTo(-length, width)
result = result.lineTo(-length, -width/2).lineTo(-width/2, -width/2)
result = result.close()

# Extrude the object
result = result.extrude(thickness)

# Add holes near the center of each leg
distance_from_edge = 0.75  # Distance from the edge to the center of the hole
hole_diameter = 0.5
result = result.faces(">Z").workplane().center(-length + distance_from_edge, width/2).hole(hole_diameter)
result = result.faces(">Z").workplane().center(width/2, length - distance_from_edge).hole(hole_diameter)

# Save the result
result.val().exportStl("Refine_V_1.stl")
