
import cadquery as cq

# Create a long rectangle and extrude it
result = cq.Workplane("front").rect(100, 10).extrude(10)

# Create two holes, positioning them at the close to end of the rectangle
result = result.faces(">Z").workplane().pushPoints([(-40, 0), (40, 0)]).hole(2)

# Save the output
result.val().exportStl("Generated.stl")
