
import cadquery as cq

# Create a rectangle and extrude it
result = cq.Workplane("XY").rect(10, 20).extrude(5)

# Create a circle positioned above the midpoint of the rectangle and negatively extrude it to create a hole
result = result.faces(">Z").workplane().circle(2).cutThruAll()

# Create a thin slit going through the rectangular block from the top of the circular hole to the shorter edge of the rectangle
result = result.faces(">Z").workplane().moveTo(0, 10).rect(0.2, 10).cutThruAll()

# Save the output
result.val().exportStl("Generated.stl")
