
import cadquery as cq

# Create a rectangular base and extrude it to the specified depth
result = cq.Workplane("front").rect(20, 20).extrude(5)

# Create a large centered hole
result = result.faces(">Z").workplane().hole(4)

# Create two smaller holes positioned horizontally around the central hole
# The coordinates can be adjusted to center the holes accordingly with respect to the rectangle's size.
result = result.faces(">Z").workplane().center(-5, 0).hole(1)
result = result.faces(">Z").workplane().center(5, 0).hole(1)

# Export the final model to an STL file
result.val().exportStl("Refine_V_2.stl")
