
import cadquery as cq

# Define the points to create an "h" shape suitable for a bench
points = [(0, 0), (10, 0), (10, 3), (7, 3), (7, 6), (3, 6), (3, 3), (0, 3)]

# Create a sketch on the XY plane and close it to form a loop
sketch = cq.Workplane("XY").polyline(points).close()

# Extrude the sketch along the Z-axis
bench = sketch.extrude(1)

# Export the model as an STL file with the specified name
bench.val().exportStl("Refine_V_1.stl")
