
import cadquery as cq

# Define the dimensions
large_diameter = 20.0
small_diameter = 10.0
separation = large_diameter
extrude_height = 5.0

# Create the large circle
circle1 = cq.Workplane("front").circle(large_diameter / 2)

# Create the small circle at the appropriate separation
circle2 = cq.Workplane("front").transformed(offset=(separation, 0)).circle(small_diameter / 2)

# Determine the tangent points
tangent_line_shift = ((large_diameter / 2) ** 2 - (small_diameter / 2) ** 2 + separation ** 2) / (2 * separation)
tangent_line_shift_y = ((large_diameter / 2) ** 2 - (tangent_line_shift - separation) ** 2) ** 0.5

# Add tangent lines to the sketch
tangents = cq.Workplane("front")\
    .moveTo(0, tangent_line_shift_y).lineTo(tangent_line_shift, small_diameter / 2)\
    .moveTo(0, -tangent_line_shift_y).lineTo(tangent_line_shift, -small_diameter / 2)

# Combine all shapes into a single wire, form a closed shape and extrude
result = circle1.add(circle2).add(tangents).consolidateWires().toPending().extrude(extrude_height)

# Export the result to an STL file
result.val().exportStl("Refine_V_1.stl")
