
import cadquery as cq

# Define parameters
large_diameter = 20.0
small_diameter = 10.0
separation = large_diameter
extrude_height = 5.0

# Create workplane and draw the large circle
circle1 = cq.Workplane("front").circle(large_diameter / 2)

# Create another workplane, shift it right by the separation amount and draw the small circle
circle2 = cq.Workplane("front").transformed(offset=(separation, 0)).circle(small_diameter / 2)

# Calculate tangent line intersection points
intersect_large_y = (large_diameter ** 2 - (separation - small_diameter)**2 + (small_diameter **2)) / (2 * separation)
intersect_small_y = (small_diameter ** 2 - (separation - large_diameter)**2 + (large_diameter **2)) / (2 * separation)

# Draw tangent lines connecting the two circles
tangents = cq.Workplane("front")\
    .moveTo(large_diameter / 2, intersect_large_y).lineTo(separation - small_diameter / 2, intersect_small_y)\
    .moveTo(large_diameter / 2, -intersect_large_y).lineTo(separation - small_diameter / 2, -intersect_small_y)

# Combine circles and tangent lines to form a single wire
result = circle1.add(circle2).add(tangents).consolidateWires().toPending().extrude(extrude_height)

# Export to STL file
result.val().exportStl("Refine_V_2.stl")
