
import cadquery as cq

# Create a parallelogram by defining points and closing the loop
parallelogram = cq.Workplane("XY").polyline([(0, 0), (4, 0), (5, 2), (1, 2)]).close()

# Extrude the parallelogram to form a 3D object
extruded = parallelogram.extrude(10)

# Start a workplane on the top face of the extruded parallelogram, offset slightly to center the square
# Use the method `rect` to draw a square of size 3x3
square = extruded.faces(">Z").workplane().center(-0.5, 0).rect(3, 3)

# Cut the square through the entire solid, creating a square-shaped tunnel
result = square.cutThruAll()

# Save the output as an STL file
result.val().exportStl("Refine_V_1.stl")
