
import cadquery as cq

# Define dimensions
leg_height = 5.0
leg_width = 1.0
thickness = 0.5
curve_radius = 2.5

# Create the vertical leg of the 'R'
leg = cq.Workplane("front").box(leg_width, leg_height, thickness)

# Create the curved part of the 'R'
curve = (
    cq.Workplane("front")
    .moveTo(leg_width/2, leg_height)
    .threePointArc((leg_width/2 + curve_radius*0.8, leg_height + curve_radius), 
                   (leg_width + curve_radius * 0.2, leg_height))
    .lineTo(leg_width + curve_radius * 0.2, leg_height - curve_radius * 0.5)
    .threePointArc((leg_width/2 + curve_radius*0.8, leg_height - curve_radius * 0.5), 
                   (leg_width / 2, leg_height))
    .close()
    .extrude(thickness)
)

# Combine the shapes
result = leg.union(curve)

# Export the result as STL
result.val().exportStl("Refine_V_2.stl")
