
import cadquery as cq

# Create the bulb at the bottom of the thermometer
bulb = cq.Workplane("XY").circle(5).extrude(0.5)

# Create a long rectangular stem attached to the bulb
stem = (
    bulb.faces(">Z")                                  # Select the top face of the bulb
    .workplane(centerOption="CenterOfMass")           # Move workplane to the center of that face
    .rect(2, 50, forConstruction=False)               # Draw a rectangle for the stem
    .extrude(0.45, combine=True)                      # Extrude the rectangle slightly less than the bulb
)

# Combine bulb and stem to form the thermometer
thermometer = bulb.union(stem)

# Export the model to an STL file
thermometer.val().exportStl("Refine_V_2.stl")
