
import cadquery as cq

outer_diameter = 20.0
width = 2.0
inner_diameter = outer_diameter - 2 * width
hole_diameter = 1.0

ring = cq.Workplane("XY").circle(outer_diameter / 2).circle(inner_diameter / 2).extrude(width)

hole_positions = [(0, outer_diameter / 2 - width / 2), 
                  (outer_diameter / 2 - width / 2, 0), 
                  (0, -outer_diameter / 2 + width / 2)]

for pos in hole_positions:
    ring = ring.faces(">Z").workplane().center(*pos).hole(hole_diameter)

ring.val().exportStl("Refine_V_1.stl")
