
import cadquery as cq

large_cylinder_diameter = 10.0
large_cylinder_height = 5.0
small_cylinder_diameter = large_cylinder_diameter / 2
small_cylinder_height = large_cylinder_height * 5

# Create large cylinder
result = cq.Workplane("XY").circle(large_cylinder_diameter / 2).extrude(large_cylinder_height)

# Create smaller cylinder from the bottom of the large cylinder
result = result.faces("<Z").workplane().circle(small_cylinder_diameter / 2).extrude(-small_cylinder_height)

# Export the model as STL
result.val().exportStl("Refine_V_1.stl")
