
import cadquery as cq

cylinder_height = 100.0
cylinder_diameter = 10.0
hole_diameter = 8.0

# Create a long and thin cylinder
result = cq.Workplane("XY").circle(cylinder_diameter / 2).extrude(cylinder_height)

# Add a hole near the top of the cylinder
result = result.faces(">Z").workplane().hole(hole_diameter)

# Add the first hole near the bottom of the cylinder, slightly to the left of center
result = result.faces("<Z").workplane().center(-cylinder_diameter / 4, 0).hole(hole_diameter)

# Add the second hole near the bottom of the cylinder, slightly to the right of center
result = result.faces("<Z").workplane().center(cylinder_diameter / 4, 0).hole(hole_diameter)

# Save the modified model to STL
result.val().exportStl("Refine_V_1.stl")
