
import cadquery as cq

# Parameters
cylinder_height = 100.0
cylinder_diameter = 10.0
hole_diameter = 8.0

# Create cylinder
result = cq.Workplane("XY").circle(cylinder_diameter / 2).extrude(cylinder_height)

# Top hole
result = result.faces(">Z").workplane().hole(hole_diameter)

# Bottom holes
result = result.faces("<Z").workplane().center(-cylinder_diameter / 4, 0).hole(hole_diameter)
result = result.faces("<Z").workplane().center(cylinder_diameter / 4, 0).hole(hole_diameter)

# Export to STL
result.val().exportStl("Refine_V_2.stl")
