
import cadquery as cq

# Parameters
width = 15.0
height = 1.0
thickness = 0.2
hole_width = width / 2.2  # Adjusted to be slightly less than half of the rectangle's width
hole_height = height * 0.9  # Adjusted to be slightly less than the rectangle's height
margin = width / 25.0  # Space between the edges of the rectangle and the holes

# Create the base rectangle
result = cq.Workplane("XY").box(width, height, thickness)

# Create the holes symmetrically positioned along the length
result = (
    result.faces(">Z")  # Work on the top face
    .workplane()
    .rect(width - 2 * margin, hole_height, forConstruction=True)
    .vertices("<X")  # Place the first rectangle hole towards the left side
    .rect(hole_width, hole_height)
    .vertices(">X")  # Place the second rectangle hole towards the right side
    .rect(hole_width, hole_height)
    .cutBlind(-thickness)  # Cut the holes through the thickness of the rectangle
)

# Export to STL file
result.val().exportStl("Refine_V_1.stl")
