
import cadquery as cq

# Defining dimensions
width = 15.0
height = 1.0
thickness = 0.2
hole_width = width / 2.2  # Adjusted to be slightly less than half of the rectangle's width
hole_height = height * 0.9  # Adjusted to be slightly less than the rectangle's height
margin = width / 25.0  # Distance from the edge

# Create the base rectangle
result = cq.Workplane("XY").box(width, height, thickness)

# Define positions for the holes to ensure they are symmetric and do not touch each other or the edges
hole_spacing = (width - 2 * hole_width - 2 * margin) / 3

# Add the holes on top of the extruded rectangle
result = (result.faces(">Z")
          .workplane()
          .rect(hole_width + 2 * hole_spacing + margin * 2, hole_height + 2 * margin, forConstruction=True)
          .vertices("<X")
          .rect(hole_width, hole_height)
          .vertices(">X")
          .rect(hole_width, hole_height)
          .cutBlind(-thickness))

# Export the final result as an STL file
result.val().exportStl("Refine_V_2.stl")
