
import cadquery as cq

# Dimensions for the first trapezoid
base1 = 10.0  # Bottom base
base2 = 5.0   # Top base
height = 20.0
extrude_dist1 = 10.0
offset = 2.0  # Offset for larger second trapezoid

# Create first right trapezoid
result = (
    cq.Workplane("front")
    # Define the vertices of the trapezoid ensuring right angles at the bases
    .moveTo(-base1 / 2, 0)
    .lineTo(base1 / 2, 0)
    .lineTo(base2 / 2, height)
    .lineTo(-base2 / 2, height)
    .close()
    .extrude(extrude_dist1)
)

# Increase the size of the second trapezoid, and make less extrusion
extrude_dist2 = 2.0
base3 = base2 + offset  # new top base adjusted by offset
base4 = base1 + offset  # new bottom base same as the first base adjusted by offset

result2 = (
    cq.Workplane("front")
    .workplane(offset=extrude_dist1)
    # Define enlarged trapezoid on top of the first
    .moveTo(-base4 / 2, 0)
    .lineTo(base4 / 2, 0)
    .lineTo(base3 / 2, height + offset)  # slightly extended height
    .lineTo(-base3 / 2, height + offset)
    .close()
    .extrude(extrude_dist2)
)

# Union both shapes to form the final object
result = result.union(result2)

# Export the model to an STL file
result.val().exportStl("Refine_V_1.stl")
