
import cadquery as cq

# Define the dimensions for the main cylinder
d1, h1 = 10.0, 50.0  # diameter and height

# Adjusted dimensions for the second cylinder
d2, h2 = d1 / 4, h1 / 8

# Adjusted dimensions for the third cylinder, relative to the second cylinder
d3, h3 = d2 / 2, h2 * 2

# Create the main cylinder
result = cq.Workplane("XY").circle(d1 / 2).extrude(h1)

# Add the second smaller cylinder from one end of the main cylinder
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").center(0, -d1 / 4).circle(d2 / 2).extrude(h2)

# Add the third cylinder on the top of the second cylinder
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").circle(d3 / 2).extrude(h3)

# Export the final model to STL
result.val().exportStl("Refine_V_1.stl")
