
import cadquery as cq

# Dimensions for the main cylinder
d1, h1 = 10.0, 50.0  # diameter and height

# Dimensions for the second cylinder (protruding from the base, smaller)
d2, h2 = d1 / 4, h1 / 8  # 1/4th the diameter and 1/8th the height of the first cylinder

# Dimensions for the third cylinder (protruding from the second, even smaller)
d3, h3 = d2 / 2, h2 * 2  # 1/2 the diameter and twice the height of the second cylinder

# Create the main cylinder
result = cq.Workplane("XY").circle(d1 / 2).extrude(h1)

# Create the second cylinder on the base of the main cylinder
# Adjusting the centering to ensure it is below the center of the base as specified
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").center(0, -d1 / 4).circle(d2 / 2).extrude(h2)

# Create the third cylinder on top of the second cylinder
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").circle(d3 / 2).extrude(h3)

# Export the final model to STL
result.val().exportStl("Refine_V_2.stl")
