
import cadquery as cq

# Define the dimensions of the rectangle and cutout
rect_length = 10.0
rect_width = 5.0
cutout_size = 1.0

# Create the main rectangle
result = cq.Workplane("XY").rect(rect_length, rect_width).extrude(1.0)

# Calculate the positions for the centers of the square cutouts
offset_from_edges = cutout_size / 2
corners = [
    (-rect_length / 2 + offset_from_edges, -rect_width / 2 + offset_from_edges),
    (rect_length / 2 - offset_from_edges, -rect_width / 2 + offset_from_edges),
    (rect_length / 2 - offset_from_edges, rect_width / 2 - offset_from_edges),
    (-rect_length / 2 + offset_from_edges, rect_width / 2 - offset_from_edges)
]

# Apply the square cutouts to each corner
for corner in corners:
    result = result.faces(">Z").workplane().center(*corner).rect(cutout_size, cutout_size).cutBlind(-1.0)

# Export the final result as an STL file
result.val().exportStl("Refine_V_1.stl")
