
import cadquery as cq

# Create the basic extruded rectangle to represent the page
result = cq.Workplane("front").rect(200, 300).extrude(2)  # dimensions adjusted for better scale representation

# Add holes at specified top and bottom positions
# Adjusted the positions to be near the top and bottom edges of the rectangle
hole_diameter = 5
top_hole_position = (90, 145)  # 5 units from the top edge of a 300 height rectangle
bottom_hole_position = (90, -145)  # 5 units from the bottom edge

result = result.faces(">Y").workplane(centerOption="CenterOfBoundBox").pushPoints([top_hole_position, bottom_hole_position]).hole(hole_diameter)

# Save the STL file
result.val().exportStl("Refine_V_1.stl")
