
import cadquery as cq

# Points defined for a right-angled isosceles triangle
# with the right angle located at the origin (0,0)
points = [(0, 0), (1, 0), (0, 1)]

# Create the 2D sketch by defining the polyline and closing it to form a right triangle
result = cq.Workplane("XY").polyline(points).close()

# Extrude the 2D sketch to form a 3D object
result = result.extrude(1.0)

# Save the 3D model as an STL file
result.val().exportStl("Refine_V_1.stl")
