
import cadquery as cq
import math

# Define the center equilateral triangle
center_triangle_height = 3
side_length = center_triangle_height / math.sin(math.radians(60))

# Points for the equilateral triangle
center_triangle = [
    (2, 0),  # bottom left point
    (4, 0),  # bottom right point
    (3, center_triangle_height)  # top point (center)
]

# Defining the acute-angled scalene triangles, ensuring all sides and angles are different and less than 90 degrees
# Since arbitrary values are used here, it's important in a real scenario to refine these based on exact requirements.

# Points for the left scalene triangle
left_triangle = [
    (0, 0),  # Bottom left corner (shared)
    (2, 0),  # Bottom right corner (shared)
    (1, 1.8)  # Unique top to make angles acute
]

# Points for the right scalene triangle
right_triangle = [
    (4, 0),  # Bottom left corner (shared)
    (6, 0),  # Bottom right corner (shared)
    (5, 1.8)  # Unique top to make angles acute
]

# Create the Workplane and draw the triangles
result = cq.Workplane("front") \
    .polyline(left_triangle).close() \
    .moveTo(2, 0) \
    .polyline(center_triangle).close() \
    .moveTo(4, 0) \
    .polyline(right_triangle).close() \
    .extrude(1)  # Extrusion depth

result.val().exportStl("Refine_V_1.stl")
