
import cadquery as cq

# Define the dimensions for the rectangle and the squares
length = 80.0
width = 20.0
thickness = 10.0
square_length = length / 16  # 1/16 of the rectangle's length
square_thickness = thickness / 3  # 1/3 of the rectangle's extrusion

# Create the base rectangle
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Add two squares to the center of the rectangle's shorter edge
for i in [-1, 1]:
    result = (
        result
        .faces(">Z")  # Select the top face
        .workplane(centerOption="CenterOfBoundBox")
        .center(i * width / 2, 0)  # Position the center of each square
        .rect(square_length, width)  # Use the width of the rectangle for the square's width
        .extrude(square_thickness)
    )

# Export updated model
result.val().exportStl("Refine_V_2.stl")
