
import cadquery as cq

diameter = 10.0
height = 20.0
rectangle_width = 0.8 * diameter # Width of rectangle is about 4/5th the diameter of the circle.
rectangle_height = 0.1 * rectangle_width # Height of rectangle is about 1/10th the width of the rectangle.
rectangle_extrude_height = 0.5 * height # Rectangle extrudes to about half the height of the cylinder.

# Create a cylinder
result = cq.Workplane("XY").circle(diameter / 2.0).extrude(height)

# Create a centered rectangle on the top surface and extrude
result = (
    result.faces(">Z")    # Select the top face of the cylinder
    .workplane(centerOption="CenterOfMass")   # Workplane centered on the top face
    .rect(rectangle_width, rectangle_height)  # Draw the rectangle with updated dimensions
    .extrude(rectangle_extrude_height)        # Extrude the rectangle up to half the height of the cylinder
)

# Save the output as STL
result.val().exportStl("Refine_V_1.stl")
