
import cadquery as cq

diameter = 10.0
height = 20.0
rectangle_width = 0.8 * diameter  # 4/5th of the diameter
rectangle_height = 0.1 * rectangle_width  # 1/10th of the 4/5th diameter
rectangle_extrude_height = 0.5 * height  # half the height of the cylinder

result = cq.Workplane("XY").circle(diameter / 2.0).extrude(height)

# Centering the rectangle on the top face using .rect()
result = (
    result.faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")  # Ensures the rectangle is centered
    .rect(rectangle_width, rectangle_height)
    .extrude(rectangle_extrude_height)
)

result.val().exportStl("Refine_V_2.stl")
