
import cadquery as cq

# Define dimensions
square_side = 10.0
thickness = 0.5
hole_diameter = 0.1

# Create a square workplane, extrude it into a 3D object, and add a hole in the center
result = (
    cq.Workplane("XY")
    .rect(square_side, square_side, centered=True)  # Ensure the rectangle is centered
    .extrude(thickness)
    # Select the top face
    .faces(">Z")
    .workplane()
    # Create hole at the center
    .hole(hole_diameter)
)

# Export the result to STL
result.val().exportStl("Refine_V_2.stl")
