
import cadquery as cq

# Create a square and extrude it
result = cq.Workplane("XY").rect(10, 10).extrude(1)

# Cut out a right triangle from the bottom-right corner of the square
result = result.workplane().moveTo(10, 0).polyline([(0, 0), (-10, 0), (0, 10)]).close().cutThruAll()

# Export the modified model as STL
result.val().exportStl("Refine_V_1.stl")
