
import cadquery as cq

# Adjusting the dimensions so that the smaller side is clearly half the size of the larger side
# Assuming the larger side is 2.0 units (as provided initially), the smaller side should be 1.0
workplane = cq.Workplane("front").rect(2.0, 1.0)

# Adding a trapezoid to the right side of the rectangle
# Connect the longer base of the trapezoid to the right side of the rectangle
# For a right trapezoid, assuming lesser base = 1.0, greater base = 1.6, and height = 1.0
trapezoid = workplane.polyline([(1.0, 0.5), (1.6, 0.5), (1.6, -0.5), (1.0, -0.5)]).close()

# Combining the shapes and extruding to create the 3D object
result = trapezoid.extrude(1.0)

# Exporting the result to an STL file called "Refine_V_1.stl"
result.val().exportStl("Refine_V_1.stl")
