
import cadquery as cq

# Define the points for the trapezoid
points = [(0, 0), (2, 0), (3, 2), (1, 2)]

# Create a workplane and draw the trapezoid
r = cq.Workplane("front").polyline(points).close()

# Extrude the trapezoid to create a prism
result = r.extrude(5)

# Export the result
result.val().exportStl("Generated.stl")
