
import cadquery as cq

outer_radius = 10.0
inner_radius = 8.0
extrude_length = 5.0  # Reduced for a more ring-like appearance

result = (
    cq.Workplane("YZ")  # Starting workplane changed to ensure correct direction of extrusion
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(extrude_length)  # Extrusion is no longer bidirectional and shorter to form a ring shape
)

result.val().exportStl("Refine_V_2.stl")
