
import cadquery as cq

block_size = 10.0
block_height = 10.0
pipe_inner_radius = 1.5
pipe_outer_radius = 2.0
pipe_height = 9.0

# Create a square block
result = cq.Workplane("XY").box(block_size, block_size, block_height)

# Create a hole through the center of the block
result = result.faces(">Z").workplane().hole(3 * pipe_inner_radius)

# Create an annulus and extrude it to form the pipe
result = result.faces(">Z").workplane().circle(pipe_outer_radius).circle(pipe_inner_radius).extrude(pipe_height)

# For a more clear representation of the interior hole, cutting the model in half
# Demonstrating this step isn't recommended for actual STL file generation,
# as it is mainly for visualization and voids making a functional STL file here.
# result = result.cut(cq.Workplane("YZ").box(block_size, block_size, block_height, centered=(True, True, False)).translate((block_size/2, 0, 0)))

result.val().exportStl("Refine_V_2.stl")
