
import cadquery as cq

# Define the points for the irregular hexagon
points = [(0, 0), (10, 0), (8, 5), (2, 5), (0, 0)]

# Create the workplane and draw the hexagon
r = cq.Workplane("front").polyline(points)

# Extrude the hexagon
result = r.close().extrude(0.5)

# Export the result
result.val().exportStl("Generated.stl")
