
import cadquery as cq

# Define dimensions
length = 20.0
width = 10.0
height = 5.0
cylinder_height = 10.0
cylinder_diameter = length / 4.0  # Explicitly one-quarter of the rectangle's length

# Create a rectangular block
result = cq.Workplane("XY").box(length, width, height)

# Add a cylinder on top
# Center the circle on the center of the rectangle
result = result.faces(">Z").workplane().circle(cylinder_diameter / 2.0).extrude(cylinder_height)

# Export the STL file
result.val().exportStl("Refine_V_2.stl")
