
import cadquery as cq

# Define the cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Define a sketch for the trapezoidal cutout
trapezium = (
    cq.Workplane("XY")
    .moveTo(0, 10)  # Start at the top center of the cylinder
    .lineTo(2, 10)  # Move right on top edge (narrow part of trapezoid)
    .threePointArc((5, 14), (8, 10))  # Arc to create the curved part, connecting the two end points
    .lineTo(10, 10)  # Move right to complete the top edge (wide part of trapezoid)
    .lineTo(5, 10)   # End at center right, moving slightly inward to form a radial line back to center
    .close()         # Close the shape to create an isosceles trapezium
    .extrude(20)     # Extrude the cutout shape through the cylinder
)

# Apply the trapezoidal cutout to the cylinder
result = cylinder.cut(trapezium)

# Export the result as an STL file
result.val().exportStl("Refine_V_2.stl")
