
import cadquery as cq

outer_radius = 10
inner_radius = 9
angle_degrees = 60
extrude_height = 5

# Create the outer sector
outer_sector = (
    cq.Workplane("XY")
    .moveTo(0, 0)
    .radiusArc(endPoint=(outer_radius, 0), radius=outer_radius)
    .lineTo(0, 0)
    .close()
    .extrude(extrude_height)
)

# Create the inner sector on the same plane with smaller radius
inner_sector = (
    cq.Workplane("XY")
    .moveTo(0, 0)
    .radiusArc(endPoint=(inner_radius, 0), radius=inner_radius)
    .lineTo(0, 0)
    .close()
    .extrude(extrude_height)  # Begin with a positive extrusion
)

# Cut the inner sector from the outer sector
result = outer_sector.cut(inner_sector)

# Save the final object
result.val().exportStl("Refine_V_2.stl")
