
import cadquery as cq

square_size = 10.0
circle_radius = 5.0

# Create a workplane that the square will be drawn on
result = cq.Workplane("front")

# Draw the square and extrude it to form a cube
result = result.rect(square_size, square_size).extrude(square_size)

# Draw the quarter circle cutout at the appropriate position
cutout = (
    cq.Workplane("front")
    .workplane(offset=square_size)  # Move the workplane to the top of the cube
    .moveTo(square_size, square_size)  # Move to the top-right corner
    .circle(circle_radius)  # Create the full circle
    .extrude(-square_size, combine=False)  # Extrude downwards to cut the corner
    .faces(">Z")  # Select the top face of the extruded circle
    .workplane(centerOption="CenterOfMass")
    .split(keepTop=True)  # Keep only the quadrant part of the circle
)

# Cut the quarter circle from the block
result = result.cut(cutout)

# Save the result
result.val().exportStl("Refine_V_1.stl")
