
import cadquery as cq

# Specifications for the main cylinder
diameter = 20
height = 10

# Creating the main cylinder
cylinder = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Specifications for the rectangular block
block_length = diameter * 1.5  # Ensuring the length exceeds the cylinder's diameter
block_width = 3
block_height = 2

# Creating the rectangular block, centrally aligned on top of the cylinder
block = (
    cq.Workplane("XY")
    .workplane(offset=height)
    .rect(block_length, block_width)
    .extrude(block_height)
)

# Combining the cylinder and the block
whistle = cylinder.union(block)

# Adding a hole for blowing air through at the center of the block
hole_diameter = 5  # Diameter of the hole
whistle = whistle.faces(">Z").workplane().center(block_length/2 - diameter/4, 0).hole(hole_diameter)

# Exporting the object as STL
whistle.val().exportStl("Refine_V_2.stl")
