
import cadquery as cq

# Dimensions for the workbench
length = 90.0
width = 30.0
thickness = width
leg_length = 3 * width
leg_width = width / 3
rod_radius = leg_width - 2

# Create the top of the workbench
top = (
    cq.Workplane("front")
    .box(length, width, thickness, centered=(True, True, False))
    .edges("|Z")
    .fillet(2)
)

# Create one leg of the workbench
leg = (
    cq.Workplane("front")
    .box(leg_width, leg_width, leg_length, centered=(True, True, False))
    .edges("|Z")
    .fillet(2)
)

# Create the rod connecting the legs
rod = (
    cq.Workplane("front")
    .circle(rod_radius)
    .extrude(leg_length, combine=True)
)

# Reposition every components
top = top.translate((0, 0, leg_length))
left_leg = leg.translate((-length/4, 0, leg_length/2))
right_leg = leg.translate((length/4, 0, leg_length/2))
rod = rod.translate((0, 0, leg_length/2))

# Combine all parts
workbench = top.union(left_leg).union(right_leg).union(rod)

# Export the result
workbench.val().exportStl("generated.stl")
