
import cadquery as cq

# Define dimensions
square_size = 10.0
extrusion_height = 5.0
inner_square_size = 8.0
inner_extrusion_height = 4.0

# Center bottom circle dimensions
center_circle_diameter = 1.0
center_circle_extrusion_height = 4.5

# Smaller corner circles dimensions
small_circle_diameter = 0.5
small_circle_extrusion_height = 4.0
small_circle_offset = square_size / 2 - small_circle_diameter

# Create the base square and extrude
result = cq.Workplane("XY").box(square_size, square_size, extrusion_height)

# Hollow out the inside of the square
result = result.faces(">Z").workplane().rect(inner_square_size, inner_square_size).cutBlind(-inner_extrusion_height)

# Add the centered bottom circle
result = result.faces("<Z").workplane().circle(center_circle_diameter / 2).extrude(center_circle_extrusion_height)

# Add smaller circles near each corner
for x in [-1, 1]:
    for y in [-1, 1]:
        result = result.faces(">Z").workplane().center(
            x * small_circle_offset, y * small_circle_offset
        ).circle(small_circle_diameter / 2).extrude(small_circle_extrusion_height)

# Save the result to STL
result.val().exportStl("Refine_V_1.stl")
