
import cadquery as cq

# Define the dimensions of the rectangle and the holes
length = 100.0  # Length of the rectangle
width = 50.0  # Width of the rectangle
thickness = 10.0  # Thickness of the rectangle
hole_dia = 5.0  # Diameter of the holes

# Create the rectangle
result = cq.Workplane("XY").box(length, width, thickness)

# Cut the holes
for i in range(3):
    result = result.faces(">Z").workplane().pushPoints([(10 + i * 20, 10)]).hole(hole_dia)

# Export the result
result.val().exportStl("Generated.stl")
