
import cadquery as cq

# Define the dimensions of the main rectangle
length = 10
width = 5
height = 0.5

# Create the main rectangular solid
sketch = cq.Workplane("front").box(length, width, height)

# Define dimensions and positions of the cutouts
cut_length = 1
cut_width = 1
cut_height = 1

# Calculate positions for cutouts to be at the bottom-left and bottom-right
# Note: Positions consider half of their dimensions to precisely fit the corners
cut_pos_x = length/2 - cut_length/2
cut_pos_y = -width/2 + cut_width/2

# Create cutouts
cut1 = cq.Workplane("front").moveTo(-cut_pos_x, cut_pos_y).rect(cut_length, cut_width).extrude(cut_height)
cut2 = cq.Workplane("front").moveTo(cut_pos_x, cut_pos_y).rect(cut_length, cut_width).extrude(cut_height)

# Apply cutouts to the main sketch
result = sketch.cut(cut1).cut(cut2)

# Export the resulting object to STL
result.val().exportStl("Refine_V_1.stl")
