
import cadquery as cq

# Create a square base with a size of 1 by 1 units
result = cq.Workplane("front").rect(1, 1)

# Attach a semi-circle at the top of the square
result = result.moveTo(0, 0.5).threePointArc((0.5, 1), (1, 0.5))

# Close the sketch and extrude
result = result.close().extrude(1)

# Save the output
result.val().exportStl("Refine_V_1.stl")
