
import cadquery as cq

# Define the height of extrusion
extrusion_height = 2

# Creating the base rectangle and extruding it
base = cq.Workplane("XY").rect(10, 5).extrude(extrusion_height)

# Creating the top rectangle on top of the base rectangle and extruding it
top = cq.Workplane("XY").workplane(offset=2).rect(8, 4).extrude(extrusion_height)

# Combining both parts
result = base.union(top)

# Exporting to STL
result.val().exportStl("Refine_V_1.stl")
